/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');
import { Form, HasError, AlertError } from 'vform';

window.Form = Form;

Vue.component(HasError.name, HasError)
Vue.component(AlertError.name, AlertError)

import Swal from 'sweetalert2'
const Toast = Swal.mixin({
	toast: true,
	position: 'top-end',
	showConfirmButton: false,
	timer: 3000,
	timerProgressBar: true,
	onOpen: (toast) => {
	  toast.addEventListener('mouseenter', Swal.stopTimer)
	  toast.addEventListener('mouseleave', Swal.resumeTimer)
	}
  })
  
window.Toast = Toast;
  
window.Swal = Swal;

window.Fire = new Vue();



import {store} from './store/index.js';


import VueRouter from 'vue-router'

Vue.use(VueRouter)

import AlertIcon from 'vue-ionicons/dist/ios-alert.vue'
Vue.component('alert-icon', AlertIcon)



import VueGoodTablePlugin from 'vue-good-table';

// import the styles
import 'vue-good-table/dist/vue-good-table.css'

Vue.use(VueGoodTablePlugin);
/**
 * The following block of code may be used to automatically register your
 * Vue components. It will recursively scan this directory for the Vue
 * components and automatically register them with their "basename".
 *
 * Eg. ./components/ExampleComponent.vue -> <example-component></example-component>
 */

// const files = require.context('./', true, /\.vue$/i)
// files.keys().map(key => Vue.component(key.split('/').pop().split('.')[0], files(key).default))
let routes = [
	{path: '/home', component: require('./components/Dashboard.vue').default},
	{path: '/state', component: require('./components/master/State.vue').default},
	{path: '/designation', component: require('./components/master/Designation.vue').default},
	{path: '/loanPlan', component: require('./components/master/LoanPlan.vue').default},
	{path: '/bank', component: require('./components/master/Bank.vue').default},
	{path: '/softwareTiming', component: require('./components/master/SoftwareTiming.vue').default},
	{path: '/feesMaster', component: require('./components/master/FeesMaster.vue').default},
	{path: '/seriesMaster', component: require('./components/master/SeriesMaster.vue').default},
	{path: '/deductionMaster', component: require('./components/master/DeductionMaster.vue').default},
	{path: '/mixedMaster', component: require('./components/master/MixedMaster.vue').default},
	{path: '/branches', component: require('./components/master/company/Branches.vue').default},
	{path: '/groupMaster', component: require('./components/master/company/GroupMaster.vue').default},
	{path: '/profile', component: require('./components/master/company/Profile.vue').default},
	{path: '/bankAccounts', component: require('./components/master/company/BankAccounts.vue').default},
	{path: '/customer', component: require('./components/Customer/Customer.vue').default},
	{path: '/disbursement', component: require('./components/entry/Disbursement.vue').default},
	{path: '/bulkDisbursement', component: require('./components/entry/BulkDisbursement.vue').default},
	{path: '/recovery', component: require('./components/entry/Recovery.vue').default},
	{path: '/settlement', component: require('./components/entry/Settlement.vue').default},
	{path: '/pendingApplications', component: require('./components/Adjustments/PendingApplications.vue').default},
	{path: '/disapproveApplications', component: require('./components/Adjustments/DisapproveApplications.vue').default},
	{path: '/ledgerGroups', component: require('./components/master/LedgerGroups.vue').default},
	{path: '/ledgerAccounts', component: require('./components/master/LedgerAccounts.vue').default},
	{path: '/employee', component: require('./components/HRM/Employee.vue').default},
	{path: '/holidayMaster', component: require('./components/HRM/HolidayMaster.vue').default},
	{path: '/attandence', component: require('./components/HRM/Attandence.vue').default},
	{path: '/employeeLeaveReport', component: require('./components/HRM/EmployeeLeaveReport.vue').default},
	{path: '/employeeSalaryDetails', component: require('./components/HRM/EmployeeSalaryDetails.vue').default},
	{path: '/employeeAbsentDetails', component: require('./components/HRM/EmployeeAbsentDetails.vue').default},
	
	{path: '/deleteRecovery', component: require('./components/Utilities/DeleteRecovery.vue').default},
	{path: '/deleteSettlement', component: require('./components/Utilities/DeleteSettlement.vue').default},
	{path: '/memberTransfer', component: require('./components/Utilities/MemberTransfer.vue').default},
	{path: '/employeeTransfer', component: require('./components/Utilities/EmployeeTransfer.vue').default},
	{path: '/centerDayShift', component: require('./components/Utilities/CenterDayShift.vue').default},
	{path: '/updateCenterLeader', component: require('./components/Utilities/UpdateCenterLeader.vue').default},
]

Vue.component('example-component', require('./components/ExampleComponent.vue').default);

Vue.component(
  'passport-clients',
  require('./components/passport/Clients.vue').default
);

Vue.component(
  'passport-authorized-clients',
  require('./components/passport/AuthorizedClients.vue').default
);

Vue.component(
  'passport-personal-access-tokens',
  require('./components/passport/PersonalAccessTokens.vue').default
);


const router = new VueRouter({
    mode: 'history',
    routes // short for `routes: routes`
  })

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

const app = new Vue({
    el: '#app',
	router,
	store,
});
